<?php

namespace App\Http\Controllers\Crm\Department;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class DepartmentController extends Controller
{
 
   public function index(){

        if(session()->get('id') != null ){
            $depart = [];
            $department = DB::table('departments')->get();
            // dd($department);
            if(count($department) > 0){
                foreach($department as $row){
                    $sub_department = DB::table('sub_departments')->where('parent_department_id',$row->id)->get();
                    $sub_department_count = DB::table('sub_departments')->select("*")->where('parent_department_id',$row->id)->count();
                    if(count($sub_department) > 0){
                        $data = [
                            'id' => $row->id,
                            'name' => $row->name,
                            'created_at' => $row->id,
                            'updated_at' => $row->id,
                            'sub_department' => $sub_department,                       
                            'sub_department_count' => $sub_department_count                       
                        ];    
                    }
                    else{
                        $data = [
                            'id' => $row->id,
                            'name' => $row->name,
                            'created_at' => $row->id,
                            'updated_at' => $row->id,
                            'sub_department' => null,                       
                            'sub_department_count' => null                       
                        ];    
                    }
                    array_push($depart, $data);
                    
                }
            }
            // dd($depart);
            return view('pages.department',compact('depart'));
        }
        else{
            return redirect()->route('login');
        }
    }

    public function add(Request $request){
        if(session()->get('id') != null ){
            $validate = $request->validate([
                'name' => 'required',
            ]);
            
            $check_department = DB::table('departments')->where('name', $request->name)->first();
            if(empty($check_department)){
                $depart = [
                    'name' => $request->name,
                ];
    
                $insert = DB::table('departments')->insert($depart);
                if($insert){
                    toastr()->success('Department Add Successfully');
                    return redirect()->route('department');
                }else{
                    toastr()->error('Something went wrong');
                    return redirect()->route('department');
                }    
            }else{
                toastr()->error('Department already exists');
                return redirect()->route('department');
            }
        }
        else{
            return redirect()->route('login');
        }
    }

    public function edit(Request $request){
        $validate = $request->validate([
            'name' => 'required',
        ]);
        $depart = [
            'name' => $request->name,
        ];
        $update = DB::table('departments')->where('id',$request->editbrandid)->update($depart);
        if($update){
            toastr()->success('Department Update Successfully');
            return redirect()->route('department');
        }else{
            toastr()->error('Something went wrong');
            return redirect()->route('department');
        }
    }

    
    public function subDepartmentAdd(Request $request){
        $validate = $request->validate([
            'name' => 'required',
            'parent_department_id' => 'required',
        ]);

        $depart = [
            'name' => $request->name,
            'parent_department_id' => $request->parent_department_id,
        ];
        
        $check_depart = DB::table('sub_departments')->where($depart)->first();
        if(empty($check_depart)){
            $insert = DB::table('sub_departments')->insert($depart);
            if($insert){
                toastr()->success('Sub Department Add Successfully');
                return redirect()->route('department');
            }else{
                toastr()->error('Something went wrong');
                return redirect()->route('department');
            }
        }else{
            toastr()->error('Sub Department already exists');
            return redirect()->route('department');
        }
    }
    
    public function editSubDepartment(Request $request){
        
        $data = [
            'name' => $request->name,
            'parent_department_id' => $request->parent_depart_id
        ];
        $update = DB::table('sub_departments')->where('id', $request->edit_sub_depart_id)->update($data);
        if($update){
            toastr()->success('Sub Department Updated Successfully');
            return redirect()->route('department');
        }else{
            toastr()->error('Something went wrong');
            return redirect()->route('department');
        }
    }
}